import numpy as np
import Utilities.gui_creator as gc
import Utilities.plot_creator as pc

def calculate_plot_waveform():
    
    theta = np.linspace(0, 6*np.pi, 1000)
    r = theta

    x = r*np.cos(theta)
    y = r*np.sin(theta)
    
    return x, y

title = 'Spiral'
label_x, label_y = 'x', 'y'

root = gc.create_window(title, '600x600')

ax,canvas = pc.create_plot(root)

x,y = calculate_plot_waveform()

pc.update_plot(ax, canvas, x, y, label_x, label_y)


